/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import jdk.jfr.Enabled;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Period;
import jdk.jfr.Registered;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.Utils;

public final class AnnotationElement {
    private final Type type;
    private final List<Object> annotationValues;
    private final List<String> annotationNames;
    private final boolean inBootClassLoader;

    /*
     * WARNING - void declaration
     */
    AnnotationElement(Type type, List<Object> list, boolean bl) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(list);
        this.type = type;
        if (list.size() != type.getFields().size()) {
            StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
            for (ValueDescriptor object : type.getFields()) {
                stringJoiner.add(object.getName());
            }
            StringJoiner stringJoiner2 = new StringJoiner(",", "[", "]");
            for (Object object : list) {
                stringJoiner.add(String.valueOf(object));
            }
            throw new IllegalArgumentException("Annotation " + stringJoiner + " for " + type.getName() + " doesn't match number of values " + stringJoiner2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl2 = false;
        for (ValueDescriptor valueDescriptor : type.getFields()) {
            void var6_11;
            Object object = list.get((int)var6_11);
            if (object == null) {
                throw new IllegalArgumentException("Annotation value can't be null");
            }
            Class<?> clazz = object.getClass();
            if (valueDescriptor.isArray()) {
                clazz = clazz.getComponentType();
            }
            AnnotationElement.checkType(Utils.unboxType(clazz));
            arrayList.add(valueDescriptor.getName());
            arrayList2.add(object);
            ++var6_11;
        }
        this.annotationValues = Utils.smallUnmodifiable(arrayList2);
        this.annotationNames = Utils.smallUnmodifiable(arrayList);
        this.inBootClassLoader = bl;
    }

    public AnnotationElement(Class<? extends Annotation> clazz, Map<String, Object> map) {
        Map.Entry<String, Object> entry2;
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(map);
        Utils.checkRegisterPermission();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        for (Map.Entry<String, Object> entry2 : hashMap.entrySet()) {
            if (entry2.getKey() == null) {
                throw new NullPointerException("Name of annotation method can't be null");
            }
            if (entry2.getValue() != null) continue;
            throw new NullPointerException("Return value for annotation method can't be null");
        }
        if (AnnotationElement.class.isAssignableFrom(clazz) && clazz.isInterface()) {
            throw new IllegalArgumentException("Must be interface extending " + Annotation.class.getName());
        }
        if (!AnnotationElement.isKnownJFRAnnotation(clazz) && clazz.getAnnotation(MetadataDefinition.class) == null) {
            throw new IllegalArgumentException("Annotation class must be annotated with jdk.jfr.MetadataDefinition to be valid");
        }
        this.type = AnnotationElement.isKnownJFRAnnotation(clazz) ? new Type(clazz.getCanonicalName(), Type.SUPER_TYPE_ANNOTATION, Type.getTypeId(clazz)) : TypeLibrary.createAnnotationType(clazz);
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length != hashMap.size()) {
            throw new IllegalArgumentException("Number of declared methods must match size of value map");
        }
        entry2 = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet hashSet = new HashSet();
        for (Method method : methodArray) {
            Object object;
            String string = method.getName();
            Object object2 = hashMap.get(string);
            if (object2 == null) {
                throw new IllegalArgumentException("No method in annotation interface " + clazz.getName() + " matching name " + string);
            }
            Class<?> clazz2 = object2.getClass();
            if (clazz2 == Class.class) {
                throw new IllegalArgumentException("Annotation value for " + string + " can't be class");
            }
            if (object2 instanceof Enum) {
                throw new IllegalArgumentException("Annotation value for " + string + " can't be enum");
            }
            if (!clazz2.equals(object2.getClass())) {
                throw new IllegalArgumentException("Return type of annotation " + clazz2.getName() + " must match type of object" + object2.getClass());
            }
            if (clazz2.isArray()) {
                object = clazz2.getComponentType();
                AnnotationElement.checkType(object);
                if (object.equals(String.class)) {
                    String[] stringArray = (String[])object2;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] != null) continue;
                        throw new IllegalArgumentException("Annotation value for " + string + " contains null");
                    }
                }
            } else {
                clazz2 = Utils.unboxType(object2.getClass());
                AnnotationElement.checkType(clazz2);
            }
            if (hashSet.contains(string)) {
                throw new IllegalArgumentException("Value with name '" + string + "' already exists");
            }
            if (AnnotationElement.isKnownJFRAnnotation(clazz)) {
                object = new ValueDescriptor(clazz2, string, Collections.emptyList(), true);
                this.type.add((ValueDescriptor)object);
            }
            entry2.add(string);
            arrayList.add(object2);
        }
        this.annotationValues = Utils.smallUnmodifiable(arrayList);
        this.annotationNames = Utils.smallUnmodifiable(entry2);
        this.inBootClassLoader = clazz.getClassLoader() == null;
    }

    public AnnotationElement(Class<? extends Annotation> clazz, Object object) {
        this(clazz, Collections.singletonMap("value", Objects.requireNonNull(object)));
    }

    public AnnotationElement(Class<? extends Annotation> clazz) {
        this(clazz, Collections.emptyMap());
    }

    public List<Object> getValues() {
        return this.annotationValues;
    }

    public List<ValueDescriptor> getValueDescriptors() {
        return Collections.unmodifiableList(this.type.getFields());
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.type.getAnnotationElements();
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public Object getValue(String string) {
        Objects.requireNonNull(string);
        int n = 0;
        for (String object : this.annotationNames) {
            if (string.equals(object)) {
                return this.annotationValues.get(n);
            }
            ++n;
        }
        StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
        for (ValueDescriptor valueDescriptor : this.type.getFields()) {
            stringJoiner.add(valueDescriptor.getName());
        }
        throw new IllegalArgumentException("No value with name '" + string + "'. Valid names are " + stringJoiner);
    }

    public boolean hasValue(String string) {
        Objects.requireNonNull(string);
        for (String string2 : this.annotationNames) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public final <A> A getAnnotation(Class<? extends Annotation> clazz) {
        Objects.requireNonNull(clazz);
        return (A)this.type.getAnnotation(clazz);
    }

    public long getTypeId() {
        return this.type.getId();
    }

    Type getType() {
        return this.type;
    }

    private static void checkType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return;
        }
        if (clazz == String.class) {
            return;
        }
        throw new IllegalArgumentException("Only primitives types or java.lang.String are allowed");
    }

    private static boolean isKnownJFRAnnotation(Class<? extends Annotation> clazz) {
        if (clazz == Registered.class) {
            return true;
        }
        if (clazz == Threshold.class) {
            return true;
        }
        if (clazz == StackTrace.class) {
            return true;
        }
        if (clazz == Period.class) {
            return true;
        }
        return clazz == Enabled.class;
    }

    boolean isInBoot() {
        return this.inBootClassLoader;
    }
}

