/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Bits;

public class ArrayKlass
extends Klass {
    private static CIntField dimension;
    private static MetadataField higherDimension;
    private static MetadataField lowerDimension;
    private static CIntField vtableLen;
    private static OopField componentMirror;
    private static Symbol javaLangCloneableName;
    private static Symbol javaLangObjectName;
    private static Symbol javaIoSerializableName;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ArrayKlass");
        dimension = new CIntField(type.getCIntegerField("_dimension"), 0L);
        higherDimension = new MetadataField(type.getAddressField("_higher_dimension"), 0L);
        lowerDimension = new MetadataField(type.getAddressField("_lower_dimension"), 0L);
        vtableLen = new CIntField(type.getCIntegerField("_vtable_len"), 0L);
        componentMirror = new OopField(type.getOopField("_component_mirror"), 0L);
        javaLangCloneableName = null;
        javaLangObjectName = null;
        javaIoSerializableName = null;
    }

    public ArrayKlass(Address addr) {
        super(addr);
    }

    @Override
    public Klass getJavaSuper() {
        SystemDictionary sysDict = VM.getVM().getSystemDictionary();
        return sysDict.getObjectKlass();
    }

    public long getDimension() {
        return dimension.getValue(this);
    }

    public Klass getHigherDimension() {
        return (Klass)higherDimension.getValue(this);
    }

    public Klass getLowerDimension() {
        return (Klass)lowerDimension.getValue(this);
    }

    public long getVtableLen() {
        return vtableLen.getValue(this);
    }

    public Oop getComponentMirror() {
        return componentMirror.getValue(this);
    }

    private static Symbol javaLangCloneableName() {
        if (javaLangCloneableName == null) {
            javaLangCloneableName = VM.getVM().getSymbolTable().probe("java/lang/Cloneable");
        }
        return javaLangCloneableName;
    }

    private static Symbol javaLangObjectName() {
        if (javaLangObjectName == null) {
            javaLangObjectName = VM.getVM().getSymbolTable().probe("java/lang/Object");
        }
        return javaLangObjectName;
    }

    private static Symbol javaIoSerializableName() {
        if (javaIoSerializableName == null) {
            javaIoSerializableName = VM.getVM().getSymbolTable().probe("java/io/Serializable");
        }
        return javaIoSerializableName;
    }

    @Override
    public int getClassStatus() {
        return 7;
    }

    @Override
    public long computeModifierFlags() {
        return 1041L;
    }

    public long getArrayHeaderInBytes() {
        return Bits.maskBits(this.getLayoutHelper() >> LH_HEADER_SIZE_SHIFT, 255);
    }

    public int getLog2ElementSize() {
        return Bits.maskBits(this.getLayoutHelper() >> LH_LOG2_ELEMENT_SIZE_SHIFT, 255);
    }

    public int getElementType() {
        return Bits.maskBits(this.getLayoutHelper() >> LH_ELEMENT_TYPE_SHIFT, 255);
    }

    @Override
    boolean computeSubtypeOf(Klass k) {
        Symbol name = k.getName();
        return name != null && (name.equals(ArrayKlass.javaIoSerializableName()) || name.equals(ArrayKlass.javaLangCloneableName()) || name.equals(ArrayKlass.javaLangObjectName()));
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("ArrayKlass");
    }

    @Override
    public void iterateFields(MetadataVisitor visitor) {
        super.iterateFields(visitor);
        visitor.doCInt(dimension, true);
        visitor.doMetadata(higherDimension, true);
        visitor.doMetadata(lowerDimension, true);
        visitor.doCInt(vtableLen, true);
        visitor.doOop(componentMirror, true);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ArrayKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

