/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.org.objectweb.asm.commons;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;

public class SerialVersionUIDAdder
extends ClassVisitor {
    private boolean computeSVUID;
    private boolean hasSVUID;
    private int access;
    private String name;
    private String[] interfaces;
    private Collection<Item> svuidFields = new ArrayList<Item>();
    private boolean hasStaticInitializer;
    private Collection<Item> svuidConstructors = new ArrayList<Item>();
    private Collection<Item> svuidMethods = new ArrayList<Item>();

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        this(327680, classVisitor);
        if (this.getClass() != SerialVersionUIDAdder.class) {
            throw new IllegalStateException();
        }
    }

    protected SerialVersionUIDAdder(int n, ClassVisitor classVisitor) {
        super(n, classVisitor);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        boolean bl = this.computeSVUID = (n2 & 0x200) == 0;
        if (this.computeSVUID) {
            this.name = string;
            this.access = n2;
            this.interfaces = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.interfaces, 0, stringArray.length);
        }
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (this.computeSVUID) {
            if ("<clinit>".equals(string)) {
                this.hasStaticInitializer = true;
            }
            int n2 = n & 0xD3F;
            if ((n & 2) == 0) {
                if ("<init>".equals(string)) {
                    this.svuidConstructors.add(new Item(string, n2, string2));
                } else if (!"<clinit>".equals(string)) {
                    this.svuidMethods.add(new Item(string, n2, string2));
                }
            }
        }
        return super.visitMethod(n, string, string2, string3, stringArray);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if (this.computeSVUID) {
            if ("serialVersionUID".equals(string)) {
                this.computeSVUID = false;
                this.hasSVUID = true;
            }
            if ((n & 2) == 0 || (n & 0x88) == 0) {
                int n2 = n & 0xDF;
                this.svuidFields.add(new Item(string, n2, string2));
            }
        }
        return super.visitField(n, string, string2, string3, object);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        if (this.name != null && this.name.equals(string)) {
            this.access = n;
        }
        super.visitInnerClass(string, string2, string3, n);
    }

    @Override
    public void visitEnd() {
        if (this.computeSVUID && !this.hasSVUID) {
            try {
                this.addSVUID(this.computeSVUID());
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error while computing SVUID for " + this.name, throwable);
            }
        }
        super.visitEnd();
    }

    public boolean hasSVUID() {
        return this.hasSVUID;
    }

    protected void addSVUID(long l) {
        FieldVisitor fieldVisitor = super.visitField(24, "serialVersionUID", "J", null, l);
        if (fieldVisitor != null) {
            fieldVisitor.visitEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeSVUID() throws IOException {
        long l = 0L;
        try (FilterOutputStream filterOutputStream = null;){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeUTF(this.name.replace('/', '.'));
            ((DataOutputStream)filterOutputStream).writeInt(this.access & 0x611);
            Arrays.sort(this.interfaces);
            for (int i = 0; i < this.interfaces.length; ++i) {
                ((DataOutputStream)filterOutputStream).writeUTF(this.interfaces[i].replace('/', '.'));
            }
            SerialVersionUIDAdder.writeItems(this.svuidFields, (DataOutput)((Object)filterOutputStream), false);
            if (this.hasStaticInitializer) {
                ((DataOutputStream)filterOutputStream).writeUTF("<clinit>");
                ((DataOutputStream)filterOutputStream).writeInt(8);
                ((DataOutputStream)filterOutputStream).writeUTF("()V");
            }
            SerialVersionUIDAdder.writeItems(this.svuidConstructors, (DataOutput)((Object)filterOutputStream), true);
            SerialVersionUIDAdder.writeItems(this.svuidMethods, (DataOutput)((Object)filterOutputStream), true);
            ((DataOutputStream)filterOutputStream).flush();
            byte[] byArray = this.computeSHAdigest(byteArrayOutputStream.toByteArray());
            for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
        }
        return l;
    }

    protected byte[] computeSHAdigest(byte[] byArray) {
        try {
            return MessageDigest.getInstance("SHA").digest(byArray);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.toString());
        }
    }

    private static void writeItems(Collection<Item> collection, DataOutput dataOutput, boolean bl) throws IOException {
        int n = collection.size();
        Object[] objectArray = collection.toArray(new Item[n]);
        Arrays.sort(objectArray);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeUTF(((Item)objectArray[i]).name);
            dataOutput.writeInt(((Item)objectArray[i]).access);
            dataOutput.writeUTF(bl ? ((Item)objectArray[i]).desc.replace('/', '.') : ((Item)objectArray[i]).desc);
        }
    }

    private static class Item
    implements Comparable<Item> {
        final String name;
        final int access;
        final String desc;

        Item(String string, int n, String string2) {
            this.name = string;
            this.access = n;
            this.desc = string2;
        }

        @Override
        public int compareTo(Item item) {
            int n = this.name.compareTo(item.name);
            if (n == 0) {
                n = this.desc.compareTo(item.desc);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Item) {
                return this.compareTo((Item)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (this.name + this.desc).hashCode();
        }
    }
}

